/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity.model;

import java.util.ArrayList;
import java.util.List;
import net.jayjay.dangerzone.shapes.Cube;
import org.lwjgl.opengl.GL11;

public class ModelRenderer {
    private List<Cube> cubes = new ArrayList<Cube>();
    private List<ModelRenderer> children = new ArrayList<ModelRenderer>();
    private int textureOffsetX;
    private int textureOffsetY;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public float xRotPoint;
    public float yRotPoint;
    public float zRotPoint;
    public boolean mirror = false;
    public boolean visible = true;
    private boolean compiled = false;
    private int displayList = 0;

    public ModelRenderer(int textureOffsetX, int textureOffsetY) {
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
    }

    public ModelRenderer setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public ModelRenderer addBox(float x, float y, float z, int width, int height, int depth) {
        Cube cube = new Cube(this.textureOffsetX, this.textureOffsetY);
        if (this.mirror) {
            cube.addBox(-(x + (float)width), y, z, width, height, depth);
        } else {
            cube.addBox(x, y, z, width, height, depth);
        }
        this.cubes.add(cube);
        this.compiled = false;
        return this;
    }

    public ModelRenderer addBox(float x, float y, float z, int width, int height, int depth, int texOffsetX, int texOffsetY) {
        Cube cube = new Cube(texOffsetX, texOffsetY);
        if (this.mirror) {
            cube.addBox(-(x + (float)width), y, z, width, height, depth);
        } else {
            cube.addBox(x, y, z, width, height, depth);
        }
        this.cubes.add(cube);
        this.compiled = false;
        return this;
    }

    public void setRotationPoint(float x, float y, float z) {
        this.xRotPoint = x;
        this.yRotPoint = y;
        this.zRotPoint = z;
    }

    public void setPos(float x, float y, float z) {
        this.setRotationPoint(x, y, z);
    }

    public void addChild(ModelRenderer child) {
        this.children.add(child);
    }

    public void render(float scale) {
        if (!this.visible) {
            return;
        }
        if (!this.compiled) {
            this.compile();
        }
        float radToDeg = 57.29578f;
        GL11.glPushMatrix();
        GL11.glTranslatef(this.xRotPoint * scale, this.yRotPoint * scale, this.zRotPoint * scale);
        if (this.zRot != 0.0f) {
            GL11.glRotatef(this.zRot * radToDeg, 0.0f, 0.0f, 1.0f);
        }
        if (this.yRot != 0.0f) {
            GL11.glRotatef(this.yRot * radToDeg, 0.0f, 1.0f, 0.0f);
        }
        if (this.xRot != 0.0f) {
            GL11.glRotatef(this.xRot * radToDeg, 1.0f, 0.0f, 0.0f);
        }
        if (this.displayList != 0) {
            GL11.glCallList(this.displayList);
        }
        for (ModelRenderer child : this.children) {
            child.render(scale);
        }
        GL11.glPopMatrix();
    }

    public void render() {
        this.render(1.0f);
    }

    private void compile() {
        if (this.displayList == 0) {
            this.displayList = GL11.glGenLists(1);
        }
        GL11.glNewList(this.displayList, 4864);
        GL11.glBegin(7);
        for (Cube cube : this.cubes) {
            cube.render();
        }
        GL11.glEnd();
        GL11.glEndList();
        this.compiled = true;
    }

    public void resetRotations() {
        this.xRot = 0.0f;
        this.yRot = 0.0f;
        this.zRot = 0.0f;
    }

    public void setRotationDegrees(float xDeg, float yDeg, float zDeg) {
        this.xRot = xDeg * ((float)Math.PI / 180);
        this.yRot = yDeg * ((float)Math.PI / 180);
        this.zRot = zDeg * ((float)Math.PI / 180);
    }

    public void setRotation(float x, float y, float z) {
        this.xRot = x;
        this.yRot = y;
        this.zRot = z;
    }
}

